Option Explicit

Const scriptName = "Change To UPPERCASE"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.1 - December 2, 2002 - MJM - Added turning off the  caps styles.
'                                  Restored the text selection afterwards.
' 1.0.0 - November 27, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a text selection."


' Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim textSel, isTextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

' Sanity check
If errNum = 0 Then
  On Error Resume Next
  Set textSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  ElseIf (textSel.End < textSel.Start) Then
    ' insertion point
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

If errNum = 0 Then
  textSel.UpperCase = False
  textSel.LowerCase = False
  textSel.TitleCase = False
  'textSel.SmallCaps = False
  textSel.Text = UCase(textSel.Text)
  textSel.Select
End If
